package mcfall.raytracer.objects;

import java.util.ArrayList;
import java.util.List;

import mcfall.math.IncompatibleMatrixException;
import mcfall.math.Matrix;
import mcfall.math.NotInvertibleException;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;
/**
 * GenericSphere represents a sphere of radius 1, centered at the origin.  
 * @author mcfall
 *
 */
public class GenericSphere extends AbstractBoundingBox  {
	
	public GenericSphere () {
		super (new Point(0,0,0), new Point(Math.sqrt(2d),Math.sqrt(2d),Math.sqrt(2d)));
	}
	
	/**
	 * Constructs a GenericSphere object with the given name
	 * @param name the name to associate with this object
	 */
	public GenericSphere (String name) {
		super(name,new Point(0,0,0), new Point(1d,1d,1d));
	}
	
	@Override	
	protected List<HitRecord> genericHitTime(Ray ray) {		
		return new java.util.ArrayList<HitRecord> ();
	}

	@Override
	protected String getObjectType() {
		return ("Generic Sphere");
	}
			
}
